/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CStack.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CStack_h	// [
#define Included_CStack_h

#include "pgpClassesConfig.h"
#include "CList.h"

_PGP_BEGIN

// Class CStack

template <typename T, bool e = PGP_EXCEPTIONS> class CStack
{
	NOT_COPYABLE(CStack)

public:
	CStack() { }
	~CStack() { }

	PGPUInt32	Size() const {return mList.Count();}

	void	Push(T *pItem);
	T *		Pop();

	void	Empty() {mList.Empty();}
	void	EmptyWithDelete() {mList.EmptyWithDelete();}

private:
	CList<T>	mList;
};

// Class CStack template member functions.

template <typename T, bool e>
void 
CStack<T, e>::Push(T *pItem)
{
	mList.AddHead(pItem);
}

template <typename T, bool e >
T * 
CStack<T, e>::Pop()
{
	if (Size() == 0)
		return NULL;
	else
		return mList.Remove(mList.Head());
}

_PGP_END

#endif	// ] Included_CStack_h
